%% Stability Diagram Autocorr %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%% SCRIPT DESCRIPTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This studies a stability diagram taken with QTlab
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Loading and extracting data

if len(field_names) < 4
    data_position = [1 2 3];
    newscritp_flag = 0;
else
    if strfind(info.Filename, '_SDGT')
    data_position = [3 1 4 2 5]; % [Gate Bias Current MCtemp Timestamp] (their position in data)
    else
        data_position = [1 3 4 2 5]; % [Gate Bias Current MCtemp Timestamp] (their position in data)
    end    
    RAW_MCtemp_mK   = data.(field_names{data_position(4)})*1000;  
    RAW_timestamp_s = data.(field_names{data_position(5)});
    newscritp_flag = 1;
end

RAW_Vg_V            = data.(field_names{data_position(1)});
RAW_Vsd_mV          = data.(field_names{data_position(2)});
RAW_Isd_A           = data.(field_names{data_position(3)});
Vg                  = RAW_Vg_V;
Vsd                 = RAW_Vsd_mV;

if newscritp_flag

    info.MeasureDuration_m      = RAW_timestamp_s(end)/60;
    info.PointsPerSecond        = 1/(mode(diff(RAW_timestamp_s)));
    info.MixingChamberTemp_mK   = mean (RAW_MCtemp_mK);
    disp (info)     
end

% Buildin the RAWdata MAP
if strfind(info.Filename, '_SDGT')
    [Vg_V_mesh,Vsd_mV_mesh, RAW_Isd_A] = map_builder(RAW_Vg_V,RAW_Vsd_mV,RAW_Isd_A);
else
    [Vsd_mV_mesh,Vg_V_mesh, RAW_Isd_A] = map_builder(RAW_Vsd_mV,RAW_Vg_V,RAW_Isd_A);
end


% GAUSS SMOOTHING

% gaussF_sigma_Isd_G = {gaussF_iso*[1 gaussF_uniso_XY],... sigma value for the I-Current map
%                       gaussF_iso*[1 gauss_uniso_IdI*gaussF_uniso_XY]};   % sigma value for G-Conductance map

gaussfilt_RAW   = gaussFilter_ISO_X_Y_dXdY (1)* [gaussFilter_ISO_X_Y_dXdY(3)  gaussFilter_ISO_X_Y_dXdY(2)];   % [sgima_B Sigma_V]
gaussfilt_dIdV  = gaussFilter_ISO_X_Y_dXdY (1)* [gaussFilter_ISO_X_Y_dXdY(3)  gaussFilter_ISO_X_Y_dXdY(2)*gaussFilter_ISO_X_Y_dXdY(4)];;     % [0 to not diff; sgima_B Sigma_V]

%% DATA analysis and smoothing
K = physics_units;

G_G0 =  diff(RAW_Isd_A,1,2)/(RAW_Vsd_mV(2)- RAW_Vsd_mV(1))/K.G0*1000;

% Gauss SMoothing
Isd_A_smoothed      = imgaussfilt(RAW_Isd_A,gaussfilt_RAW);
G_G0_Isd_smoothed   =  diff(Isd_A_smoothed,1,2)/(RAW_Vsd_mV(2)- RAW_Vsd_mV(1))/K.G0*1000;
G_G0_smoothed       =  imgaussfilt(G_G0_Isd_smoothed,gaussfilt_dIdV); 
filtering_string    = ['ImGaussFiltering, \sigma_x=',...
                        num2str(gaussfilt_RAW(1)) ';' num2str(gaussfilt_dIdV(1)),...
                        ' \\ \sigma_y=',...
                        num2str(gaussfilt_RAW(2)) ';' num2str(gaussfilt_dIdV(2))];


G_G0_log = log10(abs(G_G0_smoothed));

% getting indexes of selected bias and gate.
if exist('cursor_info','var') 
    extract_BTatVg_GTatVsd  = [ cursor_info.Position(1),...
                                cursor_info.Position(2)];
end
[~, Vbias_plot_idx] = min(abs(RAW_Vsd_mV - extract_BTatVg_GTatVsd(2)));
if Vbias_plot_idx == length (RAW_Vsd_mV)
   Vbias_plot_idx = Vbias_plot_idx - 1;
end
[~, Vg_plot_idx] = min(abs(Vg_V_mesh(:) - extract_BTatVg_GTatVsd(1)));    


 
%% Stability diagrams  - Current plots
% if caxisSigma;   caxis_current = caxisSigma*std((RAW_Isd_A(:)))*[-1 1]+ mean((RAW_Isd_A(:)));
% else                caxis_current = caxisFixed{1}; end
% %
% figure (1), clf
% set (gcf, 'Name','Stability Diagrams','NumberTitle','off')
% 
% SD_I_ax = axes('Position', [.15 .55 .70 .45 ]); axis off
%     surf(Vg_V_mesh,Vsd_mV_mesh,Isd_A_smoothed);
%     shading (shading_choice); view(2); axis tight, axis off
%     colorbar('Position', [.85 .6 .02 .3 ]), caxis (caxis_current),
%     hold on

    % bias line with contour
%     plot3 ([RAW_Vg_V(1), RAW_Vg_V(end)],RAW_Vsd_mV(Vbias_plot_idx)*[1,1],max(Isd_A_smoothed(:))*[1 1],'k','LineWidth',6);
%     plot3 ([RAW_Vg_V(1), RAW_Vg_V(end)],RAW_Vsd_mV(Vbias_plot_idx)*[1,1],max(Isd_A_smoothed(:))*[1 1],'g-.','LineWidth',3);
%     % gate line with contour
%     plot3 (RAW_Vg_V(Vg_plot_idx)*[1, 1],[RAW_Vsd_mV(1),RAW_Vsd_mV(end)],max(Isd_A_smoothed(:))*[1 1],'k','LineWidth',6);
%     plot3 (RAW_Vg_V(Vg_plot_idx)*[1, 1],[RAW_Vsd_mV(1),RAW_Vsd_mV(end)],max(Isd_A_smoothed(:))*[1 1],'g-.','LineWidth',3);
%     hold off
figure (1), clf 
SD_G_ax = axes('Position', [.15 .15 .70 .80 ], ...
               'PositionConstraint', 'outerposition');
    
    if mapLog;      SDG_to_Pot = G_G0_log;
                    SDG_RAW_to_plot = log10(G_G0_Isd_smoothed);
                    G_label = 'log(G/G_0)';
        
    else            SDG_to_Pot = G_G0_smoothed;
                    SDG_RAW_to_plot = G_G0_Isd_smoothed;
                    G_label = 'G/G_0';
%                     mTextBox = uicontrol('style','text');
%                     set(mTextBox,'String','G/G0');
%                     set(mTextBox,'Position',[.5,.5,1,1]);
    end
    surf(Vg_V_mesh(:,1:end-1),Vsd_mV_mesh(:,1:end-1),SDG_to_Pot);
    shading (shading_choice); colormap(colorMap);
    view(2); axis tight
%     axis off
    
    if caxisSigma;      caxis_G = caxisSigma*std((SDG_to_Pot(:)))*[-1 1] + mean((SDG_to_Pot(~isinf(SDG_to_Pot))));
    elseif mapLog;      caxis_G = caxisFixed{3};
    else                caxis_G = caxisFixed{2};
    end
    
    xlabel('{\it V}_{G} (V)'), ylabel ('{\it V}_{SD} (mV)'), axis tight
    G_SD_cbar = colorbar('Position', [.88 .25 .02 .6 ]);
    caxis (caxis_G);
    hold on

    % bias line with contour
%     plot3 ([RAW_Vg_V(1), RAW_Vg_V(end)],RAW_Vsd_mV(Vbias_plot_idx)*[1,1],max(SDG_to_Pot(:))*[1 1],'k','LineWidth',6);
%     plot3 ([RAW_Vg_V(1), RAW_Vg_V(end)],RAW_Vsd_mV(Vbias_plot_idx)*[1,1],max(SDG_to_Pot(:))*[1 1],'g-.','LineWidth',3);
%     % gate line with contour
%     plot3 (RAW_Vg_V(Vg_plot_idx)*[1, 1],[RAW_Vsd_mV(1),RAW_Vsd_mV(end)],max(SDG_to_Pot(:))*[1 1],'k','LineWidth',6);
%     plot3 (RAW_Vg_V(Vg_plot_idx)*[1, 1],[RAW_Vsd_mV(1),RAW_Vsd_mV(end)],max(SDG_to_Pot(:))*[1 1],'g-.','LineWidth',3);
%     hold off

%linkaxes([SD_G_ax,SD_I_ax],'xy')
   
% GT_I_Extract_ax = axes('Position', [.1 .8 .6 .15 ]); set(gca,'XAxisLocation','top'); 
%     plot (RAW_Vg_V(1:size(RAW_Isd_A,1)),RAW_Isd_A(:,Vbias_plot_idx),'.',...
%         RAW_Vg_V(1:size(G_G0,1)),Isd_A_smoothed(:,Vbias_plot_idx))
%     xlabel('V_G (V)'), ylabel ('I (A)'), axis tight
%     set(gca,'XAxisLocation','top')
%     legend({'RAW','Smoothed'},'Position',[.8 .9 .1 .05])
% linkaxes([SD_G_ax,GT_I_Extract_ax],'x')
%     
% BT_I_Extract_ax = axes('Position', [.7 .5 .2 .3 ]); set(gca,'YAxisLocation','right'); set(gca,'XAxisLocation','top'); 
%     plot (RAW_Isd_A(Vg_plot_idx,:),RAW_Vsd_mV,'.',...
%         Isd_A_smoothed(Vg_plot_idx,:),RAW_Vsd_mV)
%     set(gca,'XAxisLocation','top','YAxisLocation','right'), axis tight
%     ylabel('Vs (mV)'), xlabel ('I (A)')
% linkaxes([SD_G_ax,BT_I_Extract_ax],'y')
%     
% GT_G_Extract_ax = axes('Position', [.1 .05 .6 .15 ]);
%     plot (RAW_Vg_V(1:size(G_G0,1)),...
%             SDG_RAW_to_plot(:,Vbias_plot_idx),'.',...
%         RAW_Vg_V(1:size(G_G0,1)),...
%             SDG_to_Pot(:,Vbias_plot_idx))
%     xlabel('V_G (V)'), ylabel (G_label), axis tight
% linkaxes([SD_G_ax,GT_G_Extract_ax],'x')
%     
% BT_G_Extract_ax = axes('Position', [.7 .2 .2 .3 ]);
%     plot(SDG_RAW_to_plot(Vg_plot_idx,:),...
%             RAW_Vsd_mV(1:end-1),'.',...
%         SDG_to_Pot(Vg_plot_idx,:),...
%             RAW_Vsd_mV(1:end-1));       hold off
%     legend({'Isd_smooth','Smoothed'},'Position',[.8 .05 .1 .05]);
%     linkaxes([SD_G_ax,BT_G_Extract_ax],'y')
% 	set(gca,'YAxisLocation','right'); axis tight,
%     ylabel('Vs (mV)'),  xlabel (G_label) 

if not(exist ('keep_data','var'))
    keep_data = cell(0);
end
data_keep.Vg_V = RAW_Vg_V(Vg_plot_idx);
data_keep.Vsd_mV = RAW_Vsd_mV(1:end-1);
data_keep.G_G0 = G_G0_smoothed(Vg_plot_idx,:);
keep_data{end+1}.data = data_keep;

hAllAxes = findobj(gcf,'type','axes');
if ~isempty(data_window_X_Y{1}), hAllAxes(end).XLim = data_window_X_Y{1};end
if ~isempty(data_window_X_Y{2}),  hAllAxes(end).YLim = data_window_X_Y{2};end
colormap(colorMap)

%textax = axes('Position',[0.01 0.01 1 .05],'Visible','off');
%text(.1,.015,info.Filename,'interpreter','none')

if ~islogical(flag_save); figsave([info.Filename  flag_save ' - SDs'],0,[4 6])
    if saving_fig;figsave([info.Filename  flag_save ' - SDs'],0,[4 6],'fig');end
end

